@extends('admin-layouts.app')

@section('admin_content')
<div class="row">
    <div class="col-lg-12">
    <div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Edit Slider</h3>
              </div>
              <!-- /.card-header -->
              <!-- form start -->
              <form action="{{ route('slider.update', $slider->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="card-body">
                  <div class="form-group">
                    <label for="title">Slider Title</label>
                    <input type="text" class="form-control" name="title" id="title" value="{{ $slider->title }}">
                  </div>
                  <div class="form-group">
                    <label for="sub_title">Slider Sub Title</label>
                    <input type="text" class="form-control" name="sub_title" id="sub_title" value="{{ $slider->sub_title }}">
                  </div>
                  <div class="form-group">
                    <label for="image">Slider Image</label>
                      <div>
                        <img src="{{ asset('uploads/slider/'.$slider->image) }}" 
                         alt="" style="height: 100px; width: 170px;">
                      </div>
                    <div class="input-group">                      
                      <div class="custom-file">
                        <input type="file" class="custom-file-input" name="image" id="image">
                        <label class="custom-file-label" for="exampleInputFile">Choose file</label>
                      </div>
                      <div class="input-group-append">
                        <span class="input-group-text">Upload</span>
                      </div>
                    </div>
                  </div>
                </div>
                <!-- /.card-body -->

                <div class="card-footer">
                  <button type="submit" class="btn btn-primary">Update</button>
                </div>
              </form>
            </div>
    </div>
</div>
@endsection