@extends('admin-layouts.app')

@section('admin_content')
<a href="{{ route('slider.create') }}" class="btn btn-primary">Add New</a>
    <div class="card">
              <div class="card-header">                
                <h3 class="card-title">All Slider</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Sl</th>
                    <th>Slider Title</th>
                    <th>Slider Sub Title</th>
                    <th>Slider Image</th>
                    <th>Action</th>
                  </tr>
                  </thead>
                  <tbody>               
                    @foreach($sliders as $key=>$slider)
                      <tr>
                        <td>{{ $key+1 }}</td>
                        <td>{{ $slider->title }}</td>
                        <td>{{ $slider->sub_title }}</td>
                        <td><img src="{{ asset('uploads/slider/'.$slider->image) }}" 
                         alt="" style="height: 100px; width: 170px;"></td>
                        <td>
                          <a href="{{ route('slider.edit', $slider->id) }}" class="btn btn-info btn-sm">Edit</a>
                          <form id="delete-form-{{ $slider->id }}" action="{{ route('slider.destroy', $slider->id) }}" method="POST">
                          @csrf
                          @method('DELETE')
                          </form>
                          <button type="button" class="btn btn-danger btn-sm" onclick="if(
                            confirm('Are you sure to delete this?')){                                        
                              event.preventDefault(); 
                              document.getElementByid('delete-form-{{ $slider->id }}').submit();
                            }else{event.preventDefault();}">Delete                       
                          </button>
                        </td>
                      </tr>
                    @endforeach
                  </tbody>
                  <tfoot>
                  <tr>
                    <!-- <th>Sl</th>
                    <th>Slider Title</th>
                    <th>Slider Sub Title</th>
                    <th>Slider Image</th>
                    <th>Action</th> -->
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
@endsection