<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\SliderController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\SaleController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


Route::get('/', [HomeController::class, 'index'])->name('welcome');

//Backhend:
Route::group(['prefix' => 'admin',  'middleware' => 'auth'], function(){
    Route::get('dashboard', [DashboardController::class, 'index'])->name('admin.dashboard');
    Route::resource('slider', SliderController::class);
});


Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::middleware(['first', 'second'])->group(function () {
    Route::get('/products', [ProductController::class, 'index']);
    Route::post('/products', [ProductController::class, 'store']);

    Route::get('/sales', [SaleController::class, 'index']);
    Route::post('/sales', [SaleController::class, 'store']);
    
});



Route::get('/employees', [EmployeeController::class, 'Index']);
Route::get('/create', [EmployeeController::class, 'create']);
Route::get('/employees/{id}', [EmployeeController::class, 'show']);
Route::post('/store', [EmployeeController::class, 'store']);
Route::get('/employees/edit/{id}',[EmployeeController::class, 'edit']);
Route::post('/employees/update/{id}', [EmployeeController::class, 'update']);
Route::post('/employees/delete/{id}', [EmployeeController::class, 'destroy']);
Route::get('/admin/sliders', [SliderController::class, 'Index']);
Route::get('/admin/create', [SliderController::class, 'create']);
Route::post('/admin/sliders', [SliderController::class, 'store']);
Route::get('/admin/{id}', [SliderController::class, 'show']);
Route::get('/admin/sliders/delete/{id}', [SliderController::class, 'Destroy']);


require __DIR__.'/auth.php';
