      <!DOCTYPE html>
      <html lang="en">

      <head>
        <meta charset="utf-8">
        <meta content="width=device-width, initial-scale=1.0" name="viewport">

        <title>Skydigital Digital (BD) Limited</title>
        <meta content="" name="description">
        <meta content="" name="keywords">

        <!-- Favicons -->
        <link href="<?php echo e(asset('frontend')); ?>/img/favicon.png" rel="icon">
        <link href="<?php echo e(asset('frontend')); ?>/img/apple-touch-icon.png" rel="apple-touch-icon">

        <!-- Google Fonts -->
        <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

        <!-- Vendor CSS Files -->
        <link href="<?php echo e(asset('frontend')); ?>/vendor/aos/aos.css" rel="stylesheet">
        <link href="<?php echo e(asset('frontend')); ?>/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
        <link href="<?php echo e(asset('frontend')); ?>/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
        <link href="<?php echo e(asset('frontend')); ?>/vendor/glightbox/css/glightbox.min.css" rel="stylesheet">
        <link href="<?php echo e(asset('frontend')); ?>/vendor/remixicon/remixicon.css" rel="stylesheet">
        <link href="<?php echo e(asset('frontend')); ?>/vendor/swiper/swiper-bundle.min.css" rel="stylesheet">

        <!-- Template Main CSS File -->
        <link href="<?php echo e(asset('frontend')); ?>/css/style.css" rel="stylesheet">

        <!-- =======================================================
        * Template Name: skydigital
        * Updated: Sep 18 2023 with Bootstrap v5.3.2
        * Template URL: https://skydigitalbd.com/skydigital-bootstrap-startup-template/
        * Author: skydigitalbd.com
        * License: https://skydigitalbd.com/license/
        ======================================================== -->
      </head>

      <body>

        <!-- ======= Header ======= -->
        <header id="header" class="header fixed-top">
          <div class="container-fluid container-xl d-flex align-items-center justify-content-between">

            <div class="logo">
              <a href="index.html" class="logo d-flex align-items-center">
                <img src="<?php echo e(asset('frontend')); ?>/img/logo.png" alt="">
                <!-- <span>SKY DIGITAL</span> -->
              </a>
            </div>

            <nav id="navbar" class="navbar">
              <ul>
                <li><a class="nav-link scrollto active" href="#hero">Home</a></li>
                <li><a class="nav-link scrollto" href="#about">About</a></li>
                <li><a class="nav-link scrollto" href="#portfolio">Portfolio</a></li>
                <li><a class="nav-link scrollto" href="#services">Services</a></li>          
                <li><a class="nav-link scrollto" href="#clients">clients</a></li>          
                <li><a class="nav-link scrollto" href="#contact">Contact</a></li>
                <li><a class="getstarted scrollto" href="<?php echo e(route('register')); ?>">Get Started</a></li>
              </ul>
              <i class="bi bi-list mobile-nav-toggle"></i>
            </nav><!-- .navbar -->

          </div>
        </header><!-- End Header -->

        <!-- ======= Hero Section ======= -->
        <section id="hero" class="hero d-flex align-items-center">

          <div class="container">
            <div class="row">
              <div class="col-lg-6 d-flex flex-column justify-content-center">
                <h1 data-aos="fade-up">We design digital products that help grow businesses</h1>
                <h2 data-aos="fade-up" data-aos-delay="400">We are team of talanted developers making applications professionally</h2>
                <div data-aos="fade-up" data-aos-delay="600">
                  <div class="text-center text-lg-start">
                    <a href="#about" class="btn-get-started scrollto d-inline-flex align-items-center justify-content-center align-self-center">
                      <span>Learn More</span>
                      <i class="bi bi-arrow-right"></i>
                    </a>
                  </div>
                </div>
              </div>
              <div class="col-lg-6 hero-img" data-aos="zoom-out" data-aos-delay="200">
                <img src="<?php echo e(asset('frontend')); ?>/img/hero-img.png" class="img-fluid" alt="">
              </div>
            </div>
          </div>

        </section><!-- End Hero -->

        <main id="main">
          <!-- ======= About Section ======= -->
          <section id="about" class="about">

            <div class="container" data-aos="fade-up">
              <div class="row">

                <div class="col-lg-6 d-flex flex-column justify-content-center" data-aos="fade-up" data-aos-delay="200">
                  <div class="content">
                    <h2>Learn more about us</h2>
                    <p>
                      We are technology solution provider to replace your old heavy weight systems. We are providing cutting edge and eye catching solutions.
                    </p>

                    <div class="text-center text-lg-start">
                      <a href="#" class="btn-read-more d-inline-flex align-items-center justify-content-center align-self-center">
                        <span>Read More</span>
                        <i class="bi bi-arrow-right"></i>
                      </a>
                    </div>              
                  </div>        
                </div>
                
                <div class="col-lg-6 d-flex align-items-center" data-aos="zoom-in" data-aos-delay="200">
                  <img src="<?php echo e(asset('frontend')); ?>/img/about.jpg" class="img-fluid" alt="">
                </div>
              </div>
            </div>

          </section><!-- End About Section -->   

            

          <!-- ======= Services Section ======= -->
          <section id="services" class="services">

            <div class="container" data-aos="fade-up">

              <header class="section-header">
                <h1>Our Services</h1>
              </header>

              <div class="row gy-4">

                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="200">
                  <div class="service-box blue">
                    <i class="ri-discuss-line icon"></i>
                    <h3>Banking Solutions</h3>
                    <p>Our Fintech Solutions enable Banks and NBFIs to retrieve and disseminate mission- critical data throughout the organization with the help of IT based services.</p>
                    <a href="#" class="read-more"><span>Read More</span> <i class="bi bi-arrow-right"></i></a>
                  </div>
                </div>

                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="300">
                  <div class="service-box blue">
                    <i class="ri-discuss-line icon"></i>
                    <h3>e-Governance Solutions</h3>
                    <p>Our e-Governance Solutions help country to provide citizen services by implementing mission- critical data throughout the organization with the help of IT based services.</p>
                    <a href="#" class="read-more"><span>Read More</span> <i class="bi bi-arrow-right"></i></a>
                  </div>
                </div>

                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="400">
                  <div class="service-box blue">
                    <i class="ri-discuss-line icon"></i>
                    <h3>Enterprise Solutions</h3>
                    <p>Our Enterprise Solutions enable companies to retrieve and disseminate mission- critical data throughout the organization with the help of IT based services.</p>
                    <a href="#" class="read-more"><span>Read More</span> <i class="bi bi-arrow-right"></i></a>
                  </div>
                </div>

                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="500">
                  <div class="service-box blue">
                    <i class="ri-discuss-line icon"></i>
                    <h3>Web Development</h3>
                    <p>Our creative and skilled web developers are always learning new techniques to deliver client’s growing needs.</p>
                    <a href="#" class="read-more"><span>Read More</span> <i class="bi bi-arrow-right"></i></a>
                  </div>
                </div>

                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="600">
                  <div class="service-box blue">
                    <i class="ri-discuss-line icon"></i>
                    <h3>Mobile Development</h3>
                    <p>We have a dedicated experienced and talented team to develop iOS/Android application as per client's requirement.</p>
                    <a href="#" class="read-more"><span>Read More</span> <i class="bi bi-arrow-right"></i></a>
                  </div>
                </div>

                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="700">
                  <div class="service-box blue">
                    <i class="ri-discuss-line icon"></i>
                    <h3>Non-Banking Financial</h3>
                    <p>We have a dedicated experienced and talented team to develop iOS/Android application as per client's requirement.</p>
                    <a href="#" class="read-more"><span>Read More</span> <i class="bi bi-arrow-right"></i></a>
                  </div>
                </div>

              </div>

            </div>

          </section><!-- End Services Section -->

          

          <!-- ======= Portfolio Section ======= -->
          <section id="portfolio" class="portfolio">

            <div class="container" data-aos="fade-up">

              <header class="section-header">
                <h1>Portfolio</h1>
                <p>Check our latest work</p>
              </header>

              <div class="row" data-aos="fade-up" data-aos-delay="100">
                <div class="col-lg-12 d-flex justify-content-center">
                  <ul id="portfolio-flters">
                    <li data-filter="*" class="filter-active">All</li>
                    <li data-filter=".filter-app">App</li>
                    <li data-filter=".filter-card">WEB</li>
                    <li data-filter=".filter-web">ERP</li>
                  </ul>
                </div>
              </div>

              <div class="row gy-4 portfolio-container" data-aos="fade-up" data-aos-delay="200">

                <div class="col-lg-4 col-md-6 portfolio-item filter-app">
                  <div class="portfolio-wrap">
                    <img src="<?php echo e(asset('frontend')); ?>/img/portfolio/portfolio-1.jpg" class="img-responsive image-resize" alt="">
                    <div class="portfolio-info">
                      <h4>CPV</h4>
                      <p>Mobile App</p>
                      <div class="portfolio-links">
                        <a href="<?php echo e(asset('frontend')); ?>/img/portfolio/portfolio-1.jpg" data-gallery="portfolioGallery" class="portfokio-lightbox" title="App 1"><i class="bi bi-plus"></i></a>
                        <a href="cpv.html" title="More Details"><i class="bi bi-link"></i></a>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="col-lg-4 col-md-6 portfolio-item filter-web">
                  <div class="portfolio-wrap">
                    <img src="<?php echo e(asset('frontend')); ?>/img/portfolio/portfolio-2.gif" class="img-responsive image-resize" alt="">
                    <div class="portfolio-info">
                      <h4>AI Chatbot</h4>
                      <div class="portfolio-links">
                        <a href="<?php echo e(asset('frontend')); ?><?php echo e(asset('frontend')); ?>/img/portfolio/portfolio-2.gif" data-gallery="portfolioGallery" class="portfokio-lightbox" title="AI Chatbot"><i class="bi bi-plus"></i></a>
                        <a href="chatbot.html" title="More Details"><i class="bi bi-link"></i></a>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="col-lg-4 col-md-6 portfolio-item filter-app">
                  <div class="portfolio-wrap">
                    <img src="<?php echo e(asset('frontend')); ?>/img/portfolio/portfolio-3.jpg" class="img-responsive image-resize" alt="">
                    <div class="portfolio-info">
                      <h4>eKYC</h4>
                      <div class="portfolio-links">
                        <a href="<?php echo e(asset('frontend')); ?>/img/portfolio/portfolio-3.jpg" data-gallery="portfolioGallery" class="portfokio-lightbox" title="eKYC"><i class="bi bi-plus"></i></a>
                        <a href="ekyc.html" title="More Details"><i class="bi bi-link"></i></a>
                      </div>
                    </div>
                  </div>
                </div>          
              </div>
            </div>
          </section><!-- End Portfolio Section -->

          

          <!-- ======= Clients Section ======= -->
          <section id="clients" class="clients">
            <div class="container">
              <div class="section-title" data-aos="fade-up" by-5>
                <h2><strong>Clients</strong></h2>
              </div>

              <div class="row no-gutters clients-wrap clearfix wow fadeInUp">
                <div class="col-lg-3 col-md-4 col-xs-6">
                  <div class="client-logo" data-aos="zoom-in"><img alt="" class="img-fluid"
                      src="<?php echo e(asset('frontend')); ?>/img/clients/client-1.png" /></div>
                </div>

                <div class="col-lg-3 col-md-4 col-xs-6">
                  <div class="client-logo" data-aos="zoom-in" data-aos-delay="100"><img alt="" class="img-fluid"
                      src="<?php echo e(asset('frontend')); ?>/img/clients/client-2.png" /></div>
                </div>

                <div class="col-lg-3 col-md-4 col-xs-6">
                  <div class="client-logo" data-aos="zoom-in" data-aos-delay="150"><img alt="" class="img-fluid"
                      src="<?php echo e(asset('frontend')); ?>/img/clients/client-3.png" /></div>
                </div>

                <div class="col-lg-3 col-md-4 col-xs-6">
                  <div class="client-logo" data-aos="zoom-in" data-aos-delay="200"><img alt="" class="img-fluid"
                      src="<?php echo e(asset('frontend')); ?>/img/clients/client-4.png" /></div>
                </div>
              </div>
            </div>
          </section>    
            
            
              

          <!-- ======= Contact Section ======= -->
          <section id="contact" class="contact">

            <div class="container" data-aos="fade-up">

              <header class="section-header">
                <p>Contact Us</p>
              </header>

              <div class="row gy-4">

                <div class="col-lg-6">

                  <div class="row gy-4">
                    <div class="col-md-6">
                      <div class="info-box">
                        <i class="bi bi-geo-alt"></i>
                        <h3>Address</h3>
                        <p>Sel Trident Tower (Level-14),<br>57 VIP Rd
                          Dhaka 1000</p>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="info-box">
                        <i class="bi bi-telephone"></i>
                        <h3>Call Us</h3>
                        <p>+88 01xxx xxxxxx<br>+88 01xxx xxxxxx</p>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="info-box">
                        <i class="bi bi-envelope"></i>
                        <h3>Email Us</h3>
                        <p>info@skydigitalbd.com</p>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="info-box">
                        <i class="bi bi-clock"></i>
                        <h3>Open Hours</h3>
                        <p>Monday - Friday<br>9:00AM - 05:00PM</p>
                      </div>
                    </div>
                  </div>

                </div>

                <div class="col-lg-6">
                  <form action="forms/contact.php" method="post" class="php-email-form">
                    <div class="row gy-4">

                      <div class="col-md-6">
                        <input type="text" name="name" class="form-control" placeholder="Your Name" required>
                      </div>

                      <div class="col-md-6 ">
                        <input type="email" class="form-control" name="email" placeholder="Your Email" required>
                      </div>

                      <div class="col-md-12">
                        <input type="text" class="form-control" name="subject" placeholder="Subject" required>
                      </div>

                      <div class="col-md-12">
                        <textarea class="form-control" name="message" rows="6" placeholder="Message" required></textarea>
                      </div>

                      <div class="col-md-12 text-center">
                        <div class="loading">Loading</div>
                        <div class="error-message"></div>
                        <div class="sent-message">Your message has been sent. Thank you!</div>

                        <button type="submit">Send Message</button>
                      </div>

                    </div>
                  </form>

                </div>

              </div>

            </div>

          </section><!-- End Contact Section -->

        </main><!-- End #main -->

        <!-- ======= Footer ======= -->
        <footer id="footer" class="footer">

          <div class="footer-newsletter">
            <div class="container">
              <div class="row justify-content-center">
                <div class="col-lg-12 text-center">
                  <h4>Our Newsletter</h4>
                  <p>Tamen quem nulla quae legam multos aute sint culpa legam noster magna</p>
                </div>
                <div class="col-lg-6">
                  <form action="" method="post">
                    <input type="email" name="email"><input type="submit" value="Subscribe">
                  </form>
                </div>
              </div>
            </div>
          </div>

          <div class="footer-top">
            <div class="container">
              <div class="row gy-4">
                <div class="col-lg-5 col-md-12 footer-info">
                  <a href="index.html" class="logo d-flex align-items-center">
                    <img src="<?php echo e(asset('frontend')); ?>/img/logo.png" alt="">
                    <!-- <span>SKY  DIGITAL</span> -->
                  </a>
                  <p>Cras fermentum odio eu feugiat lide par naso tierra. Justo eget nada terra videa magna derita valies darta donna mare fermentum iaculis eu non diam phasellus.</p>
                  <div class="social-links mt-3">
                    <a href="#" class="twitter"><i class="bi bi-twitter"></i></a>
                    <a href="#" class="facebook"><i class="bi bi-facebook"></i></a>
                    <a href="#" class="instagram"><i class="bi bi-instagram"></i></a>
                    <a href="#" class="linkedin"><i class="bi bi-linkedin"></i></a>
                  </div>
                </div>

                <div class="col-lg-2 col-6 footer-links">
                  <h4>Useful Links</h4>
                  <ul>
                    <li><i class="bi bi-chevron-right"></i> <a href="#">Home</a></li>
                    <li><i class="bi bi-chevron-right"></i> <a href="#">About us</a></li>
                    <li><i class="bi bi-chevron-right"></i> <a href="#">Services</a></li>
                    <li><i class="bi bi-chevron-right"></i> <a href="#">Terms of service</a></li>
                    <li><i class="bi bi-chevron-right"></i> <a href="#">Privacy policy</a></li>
                  </ul>
                </div>

                <div class="col-lg-2 col-6 footer-links">
                  <h4>Our Services</h4>
                  <ul>
                    <li><i class="bi bi-chevron-right"></i> <a href="#">Web Design</a></li>
                    <li><i class="bi bi-chevron-right"></i> <a href="#">Web Development</a></li>
                    <li><i class="bi bi-chevron-right"></i> <a href="#">Product Management</a></li>
                    <li><i class="bi bi-chevron-right"></i> <a href="#">Marketing</a></li>
                    <li><i class="bi bi-chevron-right"></i> <a href="#">Graphic Design</a></li>
                  </ul>
                </div>

                <div class="col-lg-3 col-md-12 footer-contact text-center text-md-start">
                  <h4>Contact Us</h4>
                  <p>
                    Sel Trident Tower (Level-14),<br>
                    57 VIP Rd,<br>
                    Dhaka 1000<br><br>
                    <strong>Phone:</strong> +88 01xxx xxxxxx<br>
                    <strong>Email:</strong> info@skydigitalbd.com<br>
                  </p>

                </div>

              </div>
            </div>
          </div>

          <div class="container">
            <div class="copyright">
              &copy; Copyright <strong>skydigital</strong>. All Rights Reserved
            </div>
            <div class="credits">
              <!-- All the links in the footer should remain intact. -->
              <!-- You can delete the links only if you purchased the pro version. -->
              <!-- Licensing information: https://skydigitalbd.com/license/ -->
              <!-- Purchase the pro version with working PHP/AJAX contact form: https://skydigitalbd.com/skydigital-bootstrap-startup-template/ -->
              Designed by: <a href="https://skydigitalbd.com/">skydigital</a>
            </div>
          </div>
        </footer><!-- End Footer -->

        <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

        <!-- Vendor JS Files -->
        <script src="<?php echo e(asset('frontend')); ?>/vendor/purecounter/purecounter_vanilla.js"></script>
        <script src="<?php echo e(asset('frontend')); ?>/vendor/aos/aos.js"></script>
        <script src="<?php echo e(asset('frontend')); ?>/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
        <script src="<?php echo e(asset('frontend')); ?>/vendor/glightbox/js/glightbox.min.js"></script>
        <script src="<?php echo e(asset('frontend')); ?>/vendor/isotope-layout/isotope.pkgd.min.js"></script>
        <script src="<?php echo e(asset('frontend')); ?>/vendor/swiper/swiper-bundle.min.js"></script>
        <script src="<?php echo e(asset('frontend')); ?>/vendor/php-email-form/validate.js"></script>

        <!-- Template Main JS File -->
        <script src="<?php echo e(asset('frontend')); ?>/js/main.js"></script>

      </body>

      </html><?php /**PATH C:\laragon\www\Frameworks\Sites\Skydigital-2.2\resources\views/welcome.blade.php ENDPATH**/ ?>