      <!DOCTYPE html>
      <html lang="en">

      <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <title>PCM Enterprise</title>

        <!-- Google Fonts -->
        <link href="https://fonts.googleapis.com/css2?family=Playfair+Display&family=Montserrat&family=Merriweather&family=Pacifico&family=Roboto+Mono&family=Bebas+Neue&family=Dancing+Script&display=swap" rel="stylesheet">

        

        <!-- Favicons -->
        <link href="<?php echo e(asset('frontend')); ?>/img/favicon.png" rel="icon">
        <link href="<?php echo e(asset('frontend')); ?>/img/apple-touch-icon.png" rel="apple-touch-icon">

        <!-- Google Fonts -->
        <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">
        <link href="https://fonts.googleapis.com/css2?family=Montserrat&display=swap" rel="stylesheet">
        <link href="https://fonts.googleapis.com/css2?family=Playfair+Display&display=swap" rel="stylesheet">

        <!-- Vendor CSS Files -->
        <link href="<?php echo e(asset('frontend')); ?>/vendor/aos/aos.css" rel="stylesheet">
        <link href="<?php echo e(asset('frontend')); ?>/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
        <link href="<?php echo e(asset('frontend')); ?>/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
        <link href="<?php echo e(asset('frontend')); ?>/vendor/glightbox/css/glightbox.min.css" rel="stylesheet">
        <link href="<?php echo e(asset('frontend')); ?>/vendor/remixicon/remixicon.css" rel="stylesheet">
        <link href="<?php echo e(asset('frontend')); ?>/vendor/swiper/swiper-bundle.min.css" rel="stylesheet">

        <!-- Template Main CSS File -->
        <link href="<?php echo e(asset('frontend')); ?>/css/style.css" rel="stylesheet">

        

        <!-- =======================================================
        * Template Name: pcm
        * Updated: Sep 18 2023 with Bootstrap v5.3.2
        * Template URL: https://pcme.com/pcm-bootstrap-startup-template/
        * Author: pcme.com
        * License: https://pcme.com/license/
        ======================================================== -->
      </head>

      <body style="margin: 0; background-color: #f8f9fa; font-family: Arial, sans-serif;">
        <div style="width: 100%;
              max-width: 100%;
              display: flex;
              justify-content: center;
              align-items: center;
              padding: 60px 20px;
              background-color: #4a90e2;
              border-radius: 12px;
              box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
              text-align: center;
            ">
              <h1 style="
                font-family: 'Playfair Display', serif;
                font-size: 48px;
                color: #ffffff;
                margin: 0;
                letter-spacing: 1.5px;
              "><br>
                PCM Enterprise
              </h1>
            </div>


        <!-- ======= Header ======= -->
        <header id="header" class="header fixed-top">
          <div class="container-fluid container-xl d-flex align-items-center justify-content-between">

            <div class="logo">
              <a href="index.html" class="logo d-flex align-items-center" style="text-decoration: none;">
                  <img src="<?php echo e(asset('frontend/img/logo.png')); ?>" alt="Logo"
                      style="height: 320px; width: auto; transition: transform 0.3s ease;"
                      onmouseover="this.style.transform='scale(2.05)';"
                      onmouseout="this.style.transform='scale(1)';">
              </a>
            </div>

            <nav id="navbar" class="navbar">
              <ul>
                <li><a class="nav-link scrollto active" href="#hero">Home</a></li>
                <li><a class="nav-link scrollto" href="#about">About</a></li>
                <li><a class="nav-link scrollto" href="#Products">Products</a></li>          
                <li><a class="nav-link scrollto" href="#clients">clients</a></li>          
                <li><a class="nav-link scrollto" href="#contact">Contact</a></li>
                <li><a class="getstarted scrollto" href="<?php echo e(route('register')); ?>">Get Started</a></li>
              </ul>
              <i class="bi bi-list mobile-nav-toggle"></i>
            </nav><!-- .navbar -->

          </div>
        </header><!-- End Header -->

        <!-- ======= Hero Section ======= -->
        <section id="hero" class="hero d-flex align-items-center">

          <div class="container">
            
            <div class="row">
              <div class="col-lg-6 d-flex flex-column justify-content-center">           

                <h1 data-aos="fade-up">We specialize in the best products for different things</h1><br>
                <h5 data-aos="fade-up" data-aos-delay="400">We are a team of tech enthusiasts committed to bringing you the latest and most reliable gadgets that make life smarter, faster and easier.</h5>
                <div data-aos="fade-up" data-aos-delay="600">
                  <div class="text-center text-lg-start">
                    <a href="#about" class="btn-get-started scrollto d-inline-flex align-items-center justify-content-center align-self-center">
                      <span>Learn More</span>
                      <i class="bi bi-arrow-right"></i>
                    </a>
                  </div>
                </div>
              </div>
              <div class="col-lg-6 hero-img" data-aos="zoom-out" data-aos-delay="200">
    <div id="heroImageSlider" class="carousel slide" data-bs-ride="carousel">

      <div class="carousel-inner">
        <div class="carousel-item active">
          <img src="<?php echo e(asset('frontend/img/hero-img1.png')); ?>" class="d-block w-100 img-fluid" alt="Slide 1">
        </div>
        <div class="carousel-item">
          <img src="<?php echo e(asset('frontend/img/hero-img2.png')); ?>" class="d-block w-100 img-fluid" alt="Slide 2">
        </div>
        <div class="carousel-item">
          <img src="<?php echo e(asset('frontend/img/hero-img3.png')); ?>" class="d-block w-100 img-fluid" alt="Slide 3">
        </div>
      </div>

      <!-- Optional Controls -->
      <button class="carousel-control-prev" type="button" data-bs-target="#heroImageSlider" data-bs-slide="prev">
        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
        <span class="visually-hidden">Previous</span>
      </button>

      <button class="carousel-control-next" type="button" data-bs-target="#heroImageSlider" data-bs-slide="next">
        <span class="carousel-control-next-icon" aria-hidden="true"></span>
        <span class="visually-hidden">Next</span>
      </button>

    </div>
  </div>

            <!-- </div>
          </div> -->

        </section><!-- End Hero -->

        <main id="main">
          <!-- ======= About Section ======= -->
          <section id="about" class="about">

            <div class="container" data-aos="fade-up">
              <div class="row">

                <div class="col-lg-6 d-flex flex-column justify-content-center" data-aos="fade-up" data-aos-delay="200">
                  <div class="content">
                    <h2>Learn more about us</h2>
                    <p>
                      At PCM Enterprise, we’re dedicated to providing the latest in technology and electronics, offering innovative products that improve your daily life. From smart devices to cutting-edge gadgets, our goal is to deliver high-quality, reliable solutions for all your needs. With a focus on customer satisfaction, we’re committed to making your tech experience seamless and enjoyable.
                    </p>

                    <div class="text-center text-lg-start">
                      <a href="#" class="btn-read-more d-inline-flex align-items-center justify-content-center align-self-center">
                        <span>Read More</span>
                        <i class="bi bi-arrow-right"></i>
                      </a>
                    </div>              
                  </div>        
                </div>
                
                <div class="col-lg-6">
<div style="display: flex; flex-direction: column; align-items: center; padding: 40px; background: transparent;">

  <!-- Top row: two images side by side, no gap -->
  <div style="display: flex; justify-content: center; width: 100%; background: transparent;">
    <img src="<?php echo e(asset('frontend/img/about1.jpg')); ?>" alt="Image 1"
         style="width: 250px; height: 250px; border-radius: 50%; object-fit: cover; margin: 0; background: transparent;">
    <img src="<?php echo e(asset('frontend/img/about2.jpg')); ?>" alt="Image 2"
         style="width: 250px; height: 250px; border-radius: 50%; object-fit: cover; margin: 0; margin-left: -22px; background: transparent;">
  </div>

  <!-- Bottom row: single image centered with negative margin -->
  <div style="margin-top: -70px; background: transparent;">
    <img src="<?php echo e(asset('frontend/img/about3.jpg')); ?>" alt="Image 3"
         style="width: 250px; height: 250px; border-radius: 50%; object-fit: cover; margin: 0; background: transparent;">
  </div>

</div>


</div>

              </div>
            </div>

          </section><!-- End About Section -->   

            

          <!-- ======= Products Section ======= -->
          <section id="Products" class="Products">

            <div class="container" data-aos="fade-up">

              <header class="section-header">
                <h1>Our Products</h1>
              </header>

              <div class="row gy-4">

                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="200">
                  <div class="service-box blue">
                    <!-- <i class="ri-discuss-line icon"></i> -->
                    
                    <a href="#" class="read-more">
                      <img src="<?php echo e(asset('frontend/img/hero-img1.png')); ?>" class="d-block w-100 img-fluid" alt="Slide 1"><br>
                      <span>Add to Cart</span> <i class="bi bi-arrow-right"></i>
                    </a>
                    <h3>Air Fryer</h3>
                    <p>Cook crispy, healthy meals fast with our compact 550W air fryer. Less oil, more flavor — perfect for quick, guilt-free cooking!</p>                  
                  </div>
                </div>

                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="200">
                  <div class="service-box blue">
                    <!-- <i class="ri-discuss-line icon"></i> -->
                    
                    <a href="#" class="read-more">
                      <img src="<?php echo e(asset('frontend/img/hero-img1.png')); ?>" class="d-block w-100 img-fluid" alt="Slide 1"><br>
                      <span>Add to Cart</span> <i class="bi bi-arrow-right"></i>
                    </a>
                    <h3>Air Fryer</h3>
                    <p>Cook crispy, healthy meals fast with our compact 550W air fryer. Less oil, more flavor — perfect for quick, guilt-free cooking!</p>                  
                  </div>
                </div>

                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="200">
                  <div class="service-box blue">
                    <!-- <i class="ri-discuss-line icon"></i> -->
                    
                    <a href="#" class="read-more">
                      <img src="<?php echo e(asset('frontend/img/hero-img1.png')); ?>" class="d-block w-100 img-fluid" alt="Slide 1"><br>
                      <span>Add to Cart</span> <i class="bi bi-arrow-right"></i>
                    </a>
                    <h3>Air Fryer</h3>
                    <p>Cook crispy, healthy meals fast with our compact 550W air fryer. Less oil, more flavor — perfect for quick, guilt-free cooking!</p>                  
                  </div>
                </div>

                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="200">
                  <div class="service-box blue">
                    <!-- <i class="ri-discuss-line icon"></i> -->
                    
                    <a href="#" class="read-more">
                      <img src="<?php echo e(asset('frontend/img/hero-img1.png')); ?>" class="d-block w-100 img-fluid" alt="Slide 1"><br>
                      <span>Add to Cart</span> <i class="bi bi-arrow-right"></i>
                    </a>
                    <h3>Air Fryer</h3>
                    <p>Cook crispy, healthy meals fast with our compact 550W air fryer. Less oil, more flavor — perfect for quick, guilt-free cooking!</p>                  
                  </div>
                </div>

                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="200">
                  <div class="service-box blue">
                    <!-- <i class="ri-discuss-line icon"></i> -->
                    
                    <a href="#" class="read-more">
                      <img src="<?php echo e(asset('frontend/img/hero-img1.png')); ?>" class="d-block w-100 img-fluid" alt="Slide 1"><br>
                      <span>Add to Cart</span> <i class="bi bi-arrow-right"></i>
                    </a>
                    <h3>Air Fryer</h3>
                    <p>Cook crispy, healthy meals fast with our compact 550W air fryer. Less oil, more flavor — perfect for quick, guilt-free cooking!</p>                  
                  </div>
                </div>

                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="200">
                  <div class="service-box blue">
                    <!-- <i class="ri-discuss-line icon"></i> -->
                    
                    <a href="#" class="read-more">
                      <img src="<?php echo e(asset('frontend/img/hero-img1.png')); ?>" class="d-block w-100 img-fluid" alt="Slide 1"><br>
                      <span>Add to Cart</span> <i class="bi bi-arrow-right"></i>
                    </a>
                    <h3>Air Fryer</h3>
                    <p>Cook crispy, healthy meals fast with our compact 550W air fryer. Less oil, more flavor — perfect for quick, guilt-free cooking!</p>                  
                  </div>
                </div>

              </div>

            </div>

          </section><!-- End Products Section -->

                   
          <!-- ======= Contact Section ======= -->
          <section id="contact" class="contact">

            <div class="container" data-aos="fade-up">

              <header class="section-header">
                <p>Contact Us</p>
              </header>

              <div class="row gy-4">

                <div class="col-lg-6">

                  <div class="row gy-4">
                    <div class="col-md-6">
                      <div class="info-box">
                        <i class="bi bi-geo-alt"></i>
                        <h3>Address</h3>
                        <p>Sel Trident Tower (Level-10),<br>57 VIP Rd
                          Dhaka 1000</p>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="info-box">
                        <i class="bi bi-telephone"></i>
                        <h3>Call Us</h3>
                        <p>+88 01963 225241<br>+88 01xxx xxxxxx</p>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="info-box">
                        <i class="bi bi-envelope"></i>
                        <h3>Email Us</h3>
                        <p>info@pcme.com</p>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="info-box">
                        <i class="bi bi-clock"></i>
                        <h3>Open Hours</h3>
                        <p>Monday - Friday<br>9:00AM - 05:00PM</p>
                      </div>
                    </div>
                  </div>

                </div>

                <div class="col-lg-6">
                  <form action="forms/contact.php" method="post" class="php-email-form">
                    <div class="row gy-4">

                      <div class="col-md-6">
                        <input type="text" name="name" class="form-control" placeholder="Your Name" required>
                      </div>

                      <div class="col-md-6 ">
                        <input type="email" class="form-control" name="email" placeholder="Your Email" required>
                      </div>

                      <div class="col-md-12">
                        <input type="text" class="form-control" name="subject" placeholder="Subject" required>
                      </div>

                      <div class="col-md-12">
                        <textarea class="form-control" name="message" rows="6" placeholder="Message" required></textarea>
                      </div>

                      <div class="col-md-12 text-center">
                        <div class="loading">Loading</div>
                        <div class="error-message"></div>
                        <div class="sent-message">Your message has been sent. Thank you!</div>

                        <button type="submit">Send Message</button>
                      </div>

                    </div>
                  </form>

                </div>

              </div>

            </div>

          </section><!-- End Contact Section -->

        </main><!-- End #main -->

        <!-- ======= Footer ======= -->
        <footer id="footer" class="footer">

          <div class="footer-newsletter">
            <div class="container">
              <div class="row justify-content-center">
                <div class="col-lg-12 text-center">
                  <h4>Our Newsletter</h4>
                  <p>Tamen quem nulla quae legam multos aute sint culpa legam noster magna</p>
                </div>
                <div class="col-lg-6">
                  <form action="" method="post">
                    <input type="email" name="email"><input type="submit" value="Subscribe">
                  </form>
                </div>
              </div>
            </div>
          </div>

          <div class="footer-top">
            <div class="container">
              <div class="row gy-4">
                <div class="col-lg-5 col-md-12 footer-info">
                  <div class="footer-info">
                  <a href="index.html" class="logo d-flex align-items-center" style="text-decoration: none;">
                      <img src="<?php echo e(asset('frontend/img/logo.png')); ?>" alt="Logo"
                          style="max-height: 190px; transition: transform 0.3s ease;"
                          onmouseover="this.style.transform='scale(1.1)';"
                          onmouseout="this.style.transform='scale(1)';">
                  </a>
              </div>

                  <p>PCM Enterprise is a trusted leader specializing in innovative solutions and quality services tailored to meet the needs of modern businesses. Committed to excellence, we deliver reliable products and exceptional customer support to help your enterprise thrive in a competitive market.</p>
                  <div class="social-links mt-3">
                    <a href="#" class="twitter"><i class="bi bi-twitter"></i></a>
                    <a href="#" class="facebook"><i class="bi bi-facebook"></i></a>
                    <a href="#" class="instagram"><i class="bi bi-instagram"></i></a>
                    <a href="#" class="linkedin"><i class="bi bi-linkedin"></i></a>
                  </div>
                </div>

                <div class="col-lg-2 col-6 footer-links">
                  <h4>Useful Links</h4>
                  <ul>
                    <li><i class="bi bi-chevron-right"></i> <a href="#">Home</a></li>
                    <li><i class="bi bi-chevron-right"></i> <a href="#">About us</a></li>
                    <li><i class="bi bi-chevron-right"></i> <a href="#">Products</a></li>
                    <li><i class="bi bi-chevron-right"></i> <a href="#">Terms of service</a></li>
                    <li><i class="bi bi-chevron-right"></i> <a href="#">Privacy policy</a></li>
                  </ul>
                </div>

                <div class="col-lg-2 col-6 footer-links">
                  <h4>Our Products</h4>
                  <ul>
                    <li><i class="bi bi-chevron-right"></i> <a href="#">Marketing</a></li>
                    <li><i class="bi bi-chevron-right"></i> <a href="#">Web Design</a></li>
                    <li><i class="bi bi-chevron-right"></i> <a href="#">Web Development</a></li>
                    <li><i class="bi bi-chevron-right"></i> <a href="#">Product Management</a></li>
                    <li><i class="bi bi-chevron-right"></i> <a href="#">Graphic Design</a></li>
                  </ul>
                </div>

                <div class="col-lg-3 col-md-12 footer-contact text-center text-md-start">
                  <h4>Contact Us</h4>
                  <p>
                    Sel Trident Tower (Level-10),<br>
                    57 VIP Rd,<br>
                    Dhaka 1000<br><br>
                    <strong>Phone:</strong> +88 01963 225241<br>
                    <strong>Email:</strong> info@pcme.com<br>
                  </p>

                </div>

              </div>
            </div>
          </div>

          <div class="container">
            <div class="copyright">
              &copy; Copyright <strong>pcm</strong>. All Rights Reserved
            </div>
            <div class="credits">
              <!-- All the links in the footer should remain intact. -->
              <!-- You can delete the links only if you purchased the pro version. -->
              <!-- Licensing information: https://pcme.com/license/ -->
              <!-- Purchase the pro version with working PHP/AJAX contact form: https://pcme.com/pcm-bootstrap-startup-template/ -->
              Designed by: <a href="https://pcme.com/">pcm</a>
            </div>
          </div>
        </footer><!-- End Footer -->

        <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

        <!-- Vendor JS Files -->
        <script src="<?php echo e(asset('frontend')); ?>/vendor/purecounter/purecounter_vanilla.js"></script>
        <script src="<?php echo e(asset('frontend')); ?>/vendor/aos/aos.js"></script>
        <script src="<?php echo e(asset('frontend')); ?>/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
        <script src="<?php echo e(asset('frontend')); ?>/vendor/glightbox/js/glightbox.min.js"></script>
        <script src="<?php echo e(asset('frontend')); ?>/vendor/isotope-layout/isotope.pkgd.min.js"></script>
        <script src="<?php echo e(asset('frontend')); ?>/vendor/swiper/swiper-bundle.min.js"></script>
        <script src="<?php echo e(asset('frontend')); ?>/vendor/php-email-form/validate.js"></script>

        <!-- Template Main JS File -->
        <script src="<?php echo e(asset('frontend')); ?>/js/main.js"></script>

      </body>

      </html><?php /**PATH D:\Prs\frames\sk2.3\resources\views/welcome.blade.php ENDPATH**/ ?>